% test RotAXXB
% 
% Copyright (C) Russell H. Taylor 2013
% For use with CIS I only
% Do not redistribute without written permission from Russell Taylor

function [Ea,Ep] = TestFrameAXXB(FxTrue)
    FaList = [];
    FbList = [];
    for i=1:10
        Fa = Frame(RotMx.randD(90,90,90),vct3.rand(-10,10));
        Fb = FxTrue.Inverse()*Fa*FxTrue;
        FaList = [FaList;Fa];
        FbList = [FbList;Fb];
    end
    Fx = FrameAXXB(FaList,FbList);
    ErrR = Fx.R.Inverse()*FxTrue.R;
    [ax,Ea]=ErrR.AxisAngle();
    Ep = norm(Fx.p-FxTrue.p);
end

